<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:wwmultisere="urn:WebWorks-XSLT-Extension-MultiSearchReplace"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwtoc="urn:WebWorks-Engine-TOC-Schema"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwpage="urn:WebWorks-Page-Template-Schema"
                              xmlns:wwlocale="urn:WebWorks-Locale-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwunits="urn:WebWorks-XSLT-Extension-Units"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl msxsl wwmode wwfiles wwdoc wwsplits wwproject wwpage wwlocale wwprogress wwlog wwfilesystem wwuri wwstring wwunits wwfilesext wwprojext wwexsldoc"
>
 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalFiles" />
 <xsl:param name="ParameterDependsType" />
 <xsl:param name="ParameterHHPPageTemplateURI" />
 <xsl:param name="ParameterLinksType" />
 <xsl:param name="ParameterSplitsType" />
 <xsl:param name="ParameterProjectSplitsType" />
 <xsl:param name="ParameterCopyFilesType" />
 <xsl:param name="ParameterBaggageFilesType" />
 <xsl:param name="ParameterTOCType" />
 <xsl:param name="ParameterIndexType" />
 <xsl:param name="ParameterPageOutputType" />
 <xsl:param name="ParameterPopupPageOutputType" />
 <xsl:param name="ParameterWrapperPageOutputType" />
 <xsl:param name="ParameterPageStyleOutputType" />
 <xsl:param name="ParameterImageOutputType" />
 <xsl:param name="ParameterThumbnailImageOutputType" />
 <xsl:param name="ParameterMergePageType" />
 <xsl:param name="ParameterType" />
 <xsl:param name="ParameterMergeType" />
 <xsl:param name="ParameterWhatIsThisTextFileType" />
 <xsl:param name="ParameterWhatIsThisHeaderFileType" />
 <xsl:param name="ParameterSplitFileType" />
 <xsl:param name="ParameterMapSplitFileType" />
 <xsl:param name="ParameterCHMSplitFileType" />
 <xsl:param name="ParameterLocaleType" />
 <xsl:param name="ParameterCategory" />
 <xsl:param name="ParameterUse" />
 <xsl:param name="ParameterDeploy" />
 <xsl:param name="ParameterMergeCategory" />
 <xsl:param name="ParameterMergeUse" />
 <xsl:param name="ParameterMergeDeploy" />
 <xsl:param name="ParameterDocumentPDFType" /> 
 <xsl:param name="ParameterGroupPDFType" />


 <xsl:output method="xml" encoding="UTF-8" indent="yes" />
 <xsl:strip-space elements="*" />


 <xsl:include href="wwtransform:uri/uri.xsl" />


 <xsl:key name="wwfiles-files-by-type" match="wwfiles:File" use="@type" />
 <xsl:key name="wwfiles-files-by-groupid-type" match="wwfiles:File" use="concat(@groupID, ':', @type)" />
 <xsl:key name="wwlinks-files-by-groupid" match="wwlinks:File" use="@groupID" />
 <xsl:key name="wwsplits-files-by-groupid-type" match="wwsplits:File" use="concat(@groupID, ':', @type)" />
 <xsl:key name="wwsplits-files-by-type" match="wwsplits:File" use="@type" />
 <xsl:key name="wwsplits-splits-by-groupid" match="wwsplits:Split" use="@groupID" />
 <xsl:key name="wwproject-formatconfigurations-by-targetid" match="wwproject:FormatConfiguration" use="@TargetID" />
 <xsl:key name="wwproject-groups-by-groupid" match="wwproject:Group" use="@GroupID" />


 <xsl:variable name="GlobalActionChecksum">
  <xsl:variable name="VarTransformChecksums">
   <xsl:value-of select="concat(wwuri:AsFilePath('wwtransform:self'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:self')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath($ParameterHHPPageTemplateURI), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath($ParameterHHPPageTemplateURI)))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:uri/uri.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:uri/uri.xsl')))" />
  </xsl:variable>
  <xsl:value-of select="wwstring:MD5Checksum($VarTransformChecksums)" />
 </xsl:variable>

 <xsl:variable name="GlobalHHPPageTemplatePath" select="wwuri:AsFilePath($ParameterHHPPageTemplateURI)" />

 <!-- Locale -->
 <!--        -->
 <xsl:variable name="GlobalLocalePath">
  <xsl:for-each select="$GlobalFiles[1]">
   <xsl:value-of select="key('wwfiles-files-by-type', $ParameterLocaleType)[1]/@path" />
  </xsl:for-each>
 </xsl:variable>
 <xsl:variable name="GlobalLocale" select="wwexsldoc:LoadXMLWithoutResolver($GlobalLocalePath)" />


 <!-- Project Splits -->
 <!--                -->
 <xsl:variable name="GlobalProjectSplitsPath">
  <xsl:for-each select="$GlobalFiles[1]">
   <xsl:value-of select="key('wwfiles-files-by-type', $ParameterProjectSplitsType)[1]/@path" />
  </xsl:for-each>
 </xsl:variable>
 <xsl:variable name="GlobalProjectSplits" select="wwexsldoc:LoadXMLWithoutResolver($GlobalProjectSplitsPath)" />


 <xsl:template match="/">
  <wwfiles:Files version="1.0">

   <!-- Iterate input documents -->
   <!--                         -->
   <xsl:for-each select="$GlobalFiles[1]">
    <!-- Load project links -->
    <!--                    -->
    <xsl:variable name="VarLinksPath" select="key('wwfiles-files-by-type', $ParameterLinksType)/@path" />
    <xsl:variable name="VarLinks" select="wwexsldoc:LoadXMLWithoutResolver($VarLinksPath)" />

    <!-- Groups -->
    <!--        -->
    <xsl:variable name="VarProjectGroups" select="$GlobalProject/wwproject:Project/wwproject:Groups/wwproject:Group" />
    <xsl:variable name="VarProgressGroupsAndMergeStart" select="wwprogress:Start(count($VarProjectGroups) + 1)" />
    <xsl:for-each select="$VarProjectGroups">
     <xsl:variable name="VarProjectGroup" select="." />

     <xsl:variable name="VarProgressGroupStart" select="wwprogress:Start(1)" />

     <!-- Link files -->
     <!--            -->
     <xsl:for-each select="$VarLinks[1]">
      <xsl:variable name="VarLinksFiles" select="key('wwlinks-files-by-groupid', $VarProjectGroup/@GroupID)" />

      <!-- Access splits -->
      <!--               -->
      <xsl:for-each select="$GlobalFiles[1]">

       <xsl:variable name="VarCopyFiles" select="key('wwfiles-files-by-groupid-type', concat($VarProjectGroup/@GroupID, ':', $ParameterCopyFilesType))" />
       <xsl:variable name="VarBaggageFiles" select="key('wwfiles-files-by-groupid-type', concat($VarProjectGroup/@GroupID, ':', $ParameterBaggageFilesType))" />

       <xsl:variable name="VarFilesNameInfo" select="key('wwfiles-files-by-groupid-type', concat($VarProjectGroup/@GroupID, ':', $ParameterSplitsType))" />
       <xsl:for-each select="$VarFilesNameInfo[1]">
        <xsl:variable name="VarSplitsFileInfo" select="." />

        <!-- Load splits -->
        <!--             -->
        <xsl:variable name="VarSplits" select="wwexsldoc:LoadXMLWithoutResolver($VarSplitsFileInfo/@path)" />

        <!-- Iterate input documents -->
        <!--                         -->
        <xsl:for-each select="$GlobalFiles[1]">
         <!-- Determine group output directory path -->
         <!--                                       -->
         <xsl:variable name="VarGroupOutputDirectoryPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), $VarProjectGroup/@Name)" />

         <xsl:variable name="VarPageOutputByType" select="key('wwfiles-files-by-groupid-type', concat($VarProjectGroup/@GroupID, ':', $ParameterPageOutputType)) | key('wwfiles-files-by-groupid-type', concat($VarProjectGroup/@GroupID, ':', $ParameterPopupPageOutputType)) | key('wwfiles-files-by-groupid-type', concat($VarProjectGroup/@GroupID, ':', $ParameterWrapperPageOutputType)) | key('wwfiles-files-by-groupid-type', concat($VarProjectGroup/@GroupID, ':', $ParameterPageStyleOutputType)) | key('wwfiles-files-by-groupid-type', concat($VarProjectGroup/@GroupID, ':', $ParameterGroupPDFType)) | key('wwfiles-files-by-groupid-type', concat($VarProjectGroup/@GroupID, ':', $ParameterDocumentPDFType))" />
         <xsl:variable name="VarImageOutputByType" select="key('wwfiles-files-by-groupid-type', concat($VarProjectGroup/@GroupID, ':', $ParameterImageOutputType)) | key('wwfiles-files-by-groupid-type', concat($VarProjectGroup/@GroupID, ':', $ParameterThumbnailImageOutputType))" />
         <xsl:variable name="VarTOCByType" select="key('wwfiles-files-by-groupid-type', concat($VarProjectGroup/@GroupID, ':', $ParameterTOCType))" />
         <xsl:variable name="VarIndexByType" select="key('wwfiles-files-by-groupid-type', concat($VarProjectGroup/@GroupID, ':', $ParameterIndexType))" />
         <xsl:variable name="VarWhatIsThisTextByType" select="key('wwfiles-files-by-groupid-type', concat($VarProjectGroup/@GroupID, ':', $ParameterWhatIsThisTextFileType))" />
         <xsl:variable name="VarWhatIsThisHeaderByType" select="key('wwfiles-files-by-groupid-type', concat($VarProjectGroup/@GroupID, ':', $ParameterWhatIsThisHeaderFileType))" />
         <xsl:variable name="VarFilesDocumentNodes" select="key('wwfiles-files-by-groupid-type', concat($VarProjectGroup/@GroupID, ':', $ParameterDependsType))" />

         <!-- Output path -->
         <!--             -->
         <xsl:variable name="VarPath">
          <xsl:for-each select="$VarSplits[1]">
           <xsl:value-of select="key('wwsplits-files-by-groupid-type', concat($VarProjectGroup/@GroupID, ':', $ParameterSplitFileType))[1]/@path"/>
          </xsl:for-each>
         </xsl:variable>

         <xsl:variable name="VarCHMPath">
          <xsl:for-each select="$VarSplits[1]">
           <xsl:variable name="VarAbsoluteCHMPath" select="key('wwsplits-files-by-groupid-type', concat($VarProjectGroup/@GroupID, ':', $ParameterCHMSplitFileType))[1]/@path"/>
           <xsl:value-of select="wwfilesystem:GetRelativeTo($VarAbsoluteCHMPath, $VarPath)" />
          </xsl:for-each>
         </xsl:variable>

         <!-- Check to see if we have a TOC -->
         <!--                               -->
         <xsl:variable name="VarTOCPath">
          <xsl:if test="string-length($VarTOCByType/@path) &gt; 0">
           <xsl:value-of select="wwfilesystem:GetRelativeTo($VarTOCByType/@path, $VarPath)" />
          </xsl:if>
         </xsl:variable>

         <!-- Check to see if we have an Index -->
         <!--                                  -->
         <xsl:variable name="VarIndexPath">
          <xsl:if test="string-length($VarIndexByType/@path) &gt; 0">
           <xsl:value-of select="wwfilesystem:GetRelativeTo($VarIndexByType/@path, $VarPath)" />
          </xsl:if>
         </xsl:variable>

         <!-- Map file -->
         <!--          -->
         <xsl:variable name="VarMapPath">
         <xsl:variable name="VarCustomMapFile" select="wwprojext:GetFormatSetting('htmlhelp-custom-map-file')" />

          <xsl:choose>
           <xsl:when test="string-length($VarCustomMapFile) &gt; 0">
            <xsl:variable name="VarTempMapPath">
             <xsl:call-template name="URI-ResolveProjectFileURI">
              <xsl:with-param name="ParamFromAbsoluteURI" select="$VarPath" />
              <xsl:with-param name="ParamSplits" select="$VarSplits" />
              <xsl:with-param name="ParamURI" select="$VarCustomMapFile" />
             </xsl:call-template>
            </xsl:variable>
            <xsl:value-of select="wwuri:Unescape($VarTempMapPath)" />
           </xsl:when>

           <xsl:otherwise>
            <xsl:variable name="VarAbsoluteMapPath">
             <xsl:for-each select="$VarSplits[1]">
              <xsl:value-of select="key('wwsplits-files-by-groupid-type', concat($VarProjectGroup/@GroupID, ':', $ParameterMapSplitFileType))[1]/@path"/>
             </xsl:for-each>
            </xsl:variable>

            <xsl:value-of select="wwfilesystem:GetRelativeTo($VarAbsoluteMapPath, $VarPath)" />
           </xsl:otherwise>
          </xsl:choose>
         </xsl:variable>

         <!-- Title -->
         <!--       -->
         <xsl:variable name="VarTitle">
          <xsl:variable name="VarMergeGroupTitle">
           <xsl:for-each select="$GlobalProject[1]">
            <xsl:variable name="VarFormatConfiguration" select="key('wwproject-formatconfigurations-by-targetid', wwprojext:GetFormatID())[1]" />
            <xsl:variable name="VarMergeSettings" select="$VarFormatConfiguration/wwproject:MergeSettings" />

            <xsl:variable name="VarMergeGroup" select="$VarMergeSettings//wwproject:MergeGroup[@GroupID = $VarProjectGroup/@GroupID]" />
            <xsl:if test="count($VarMergeGroup) &gt; 0">
             <xsl:value-of select="$VarMergeGroup/@Title" />
            </xsl:if>
           </xsl:for-each>
          </xsl:variable>

          <xsl:choose>
           <!-- Merge context -->
           <!--               -->
           <xsl:when test="string-length($VarMergeGroupTitle)">
            <xsl:value-of select="$VarMergeGroupTitle" />
           </xsl:when>

           <!-- Project group name -->
           <!--                    -->
           <xsl:otherwise>
            <xsl:value-of select="$VarProjectGroup/@Name" />
           </xsl:otherwise>
          </xsl:choose>
         </xsl:variable>

         <!-- Call template -->
         <!--               -->
         <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($VarPath, $GlobalProject/wwproject:Project/@ChangeID, $VarProjectGroup/@GroupID, '', $GlobalActionChecksum)" />
         <xsl:if test="not($VarUpToDate)">
          <xsl:call-template name="HtmlHelpProject">
           <xsl:with-param name="ParamLinksFiles" select="$VarLinksFiles" />
           <xsl:with-param name="ParamDefaultTopic" select="wwfilesystem:GetRelativeTo($VarSplits/wwsplits:Splits/wwsplits:Split[1]/@path, $VarPath)" />
           <xsl:with-param name="ParamPageOutput" select="$VarPageOutputByType" />
           <xsl:with-param name="ParamImageOutput" select="$VarImageOutputByType" />
           <xsl:with-param name="ParamOutPath" select="$VarPath" />
           <xsl:with-param name="ParamLCID" select="$GlobalLocale/wwlocale:Locale/@lcid" />
           <xsl:with-param name="ParamTitle" select="$VarTitle" />
           <xsl:with-param name="ParamTOCPath" select="$VarTOCPath" />
           <xsl:with-param name="ParamIndexPath" select="$VarIndexPath" />
           <xsl:with-param name="ParamCHMPath" select="$VarCHMPath" />
           <xsl:with-param name="ParamMapPath" select="$VarMapPath" />
           <xsl:with-param name="ParamFilesDocumentNodes" select="$VarFilesDocumentNodes" />
           <xsl:with-param name="ParamCopyFiles" select="$VarCopyFiles" />
           <xsl:with-param name="ParamBaggageFiles" select="$VarBaggageFiles" />
           <xsl:with-param name="ParamWhatIsThisTextPath" select="$VarWhatIsThisTextByType/@path" />
           <xsl:with-param name="ParamWhatIsThisHeaderPath" select="$VarWhatIsThisHeaderByType/@path" />
           <xsl:with-param name="ParamMergeFiles" select="$GlobalFiles/wwmode:EmptySelection" />
          </xsl:call-template>
         </xsl:if>

         <wwfiles:File path="{$VarPath}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($VarPath)}" projectchecksum="{$GlobalProject/wwproject:Project/@ChangeID}" groupID="{$VarProjectGroup/@GroupID}" documentID="" actionchecksum="{$GlobalActionChecksum}" category="{$ParameterCategory}" use="{$ParameterUse}" deploy="{$ParameterDeploy}">
          <wwfiles:Depends path="{$GlobalLocalePath}" checksum="{wwfilesystem:GetChecksum($GlobalLocalePath)}" groupID="" documentID="" />
          <xsl:if test="string-length($VarTOCByType/@path) &gt; 0">
           <wwfiles:Depends path="{$VarTOCByType/@path}" checksum="{$VarTOCByType/@checksum}" groupID="{$VarProjectGroup/@GroupID}" documentID="" />
          </xsl:if>
          <xsl:if test="string-length($VarIndexByType/@path) &gt; 0">
           <wwfiles:Depends path="{$VarIndexByType/@path}" checksum="{$VarIndexByType/@checksum}" groupID="{$VarProjectGroup/@GroupID}" documentID="" />
          </xsl:if>
          <xsl:for-each select="$VarPageOutputByType">
           <wwfiles:Depends path="{./@path}" checksum="{./@checksum}" groupID="{./@groupID}" documentID="{./@documentID}" />
          </xsl:for-each>
          <xsl:for-each select="$VarCopyFiles">
           <wwfiles:Depends path="{./@path}" checksum="{./@checksum}" groupID="{./@groupID}" documentID="{./@documentID}" />
          </xsl:for-each>
          <wwfiles:Depends path="{$VarWhatIsThisTextByType/@path}" checksum="{$VarWhatIsThisTextByType/@checksum}" groupID="{$VarWhatIsThisTextByType/@groupID}" documentID="{$VarWhatIsThisTextByType/@documentID}" />
          <wwfiles:Depends path="{$VarWhatIsThisHeaderByType/@path}" checksum="{$VarWhatIsThisHeaderByType/@checksum}" groupID="{$VarWhatIsThisHeaderByType/@groupID}" documentID="{$VarWhatIsThisHeaderByType/@documentID}" />
         </wwfiles:File>
        </xsl:for-each>
       </xsl:for-each>
      </xsl:for-each>

     </xsl:for-each>

     <xsl:variable name="VarProgressGroupEnd" select="wwprogress:End()" />
    </xsl:for-each>

    <!-- Merge -->
    <!--       -->
    <xsl:variable name="VarProgressMergeStart" select="wwprogress:Start(1)" />
    <xsl:if test="count($VarProjectGroups) &gt; 1">
     <!-- Merge path -->
     <!--            -->
     <xsl:variable name="VarMergePath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), concat(wwprojext:GetFormatName(), '.hhp'))" />

     <!-- Up-to-date? -->
     <!--             -->
     <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($VarMergePath, $GlobalProject/wwproject:Project/@ChangeID, '', '', $GlobalActionChecksum)" />
     <xsl:if test="not($VarUpToDate)">
      <!-- Locate merge page file -->
      <!--                        -->
      <xsl:variable name="VarMergePageFile" select="key('wwfiles-files-by-type', $ParameterMergePageType)[1]" />

      <xsl:for-each select="$GlobalProject[1]">
       <!-- Merge settings -->
       <!--                -->
       <xsl:variable name="VarFormatConfiguration" select="key('wwproject-formatconfigurations-by-targetid', wwprojext:GetFormatID())[1]" />
       <xsl:variable name="VarMergeSettings" select="$VarFormatConfiguration/wwproject:MergeSettings" />

       <xsl:variable name="VarMergeTitle">
        <xsl:choose>
         <xsl:when test="string-length($VarMergeSettings/@Title) &gt; 0">
          <xsl:value-of select="$VarMergeSettings/@Title" />
         </xsl:when>

         <xsl:otherwise>
          <xsl:value-of select="wwprojext:GetFormatName()" />
         </xsl:otherwise>
        </xsl:choose>
       </xsl:variable>

       <!-- Locate first merge group -->
       <!--                          -->
       <xsl:variable name="VarFirstMergeSettingsGroup" select="$VarMergeSettings//wwproject:MergeGroup[1]" />
       <xsl:variable name="VarFirstMergeGroup" select="key('wwproject-groups-by-groupid', $VarFirstMergeSettingsGroup/@GroupID)" />
       <xsl:variable name="VarFirstMergeGroupOutputDirectoryPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), $VarFirstMergeGroup/@Name, 'dummy.component')" />

       <xsl:for-each select="$GlobalProjectSplits[1]">
        <xsl:variable name="VarFirstMergeCHMSplit" select="key('wwsplits-files-by-groupid-type', concat($VarFirstMergeGroup/@GroupID, ':', $ParameterCHMSplitFileType))[1]" />
        <xsl:variable name="VarFirstMergePageSplit" select="key('wwsplits-splits-by-groupid', $VarFirstMergeGroup/@GroupID)[1]" />
        <xsl:variable name="VarFirstMergeCHMRelativePath" select="wwfilesystem:GetFileName($VarFirstMergeCHMSplit/@path)" />
        <xsl:variable name="VarFirstMergePageRelativePath" select="wwfilesystem:GetRelativeTo($VarFirstMergePageSplit/@path, $VarFirstMergeGroupOutputDirectoryPath)" />

        <xsl:variable name="VarMergeFiles" select="key('wwsplits-files-by-type', $ParameterCHMSplitFileType)" />

        <!-- Check to see if we have a TOC -->
        <!--                               -->
        <xsl:variable name="VarTOCPath">
         <xsl:if test="wwprojext:GetFormatSetting('toc-generate', 'true') = 'true'">
          <xsl:value-of select="concat(wwprojext:GetFormatName(), '.hhc')" />
         </xsl:if>
        </xsl:variable>

        <!-- Check to see if we have an Index -->
        <!--                                  -->
        <xsl:variable name="VarIndexPath">
         <xsl:if test="wwprojext:GetFormatSetting('index-generate', 'true') = 'true'">
          <xsl:value-of select="concat(wwprojext:GetFormatName(), '.hhk')" />
         </xsl:if>
        </xsl:variable>

        <xsl:call-template name="HtmlHelpProject">
         <xsl:with-param name="ParamLinksFiles" select="$GlobalFiles/wwmode:EmptySelection" />
         <xsl:with-param name="ParamDefaultTopic" select="concat('ms-its:', $VarFirstMergeCHMRelativePath, '::/', $VarFirstMergePageRelativePath)" />
         <xsl:with-param name="ParamPageOutput" select="$VarMergePageFile" />
         <xsl:with-param name="ParamImageOutput" select="$GlobalFiles/wwmode:EmptySelection" />
         <xsl:with-param name="ParamOutPath" select="$VarMergePath" />
         <xsl:with-param name="ParamLCID" select="$GlobalLocale/wwlocale:Locale/@lcid" />
         <xsl:with-param name="ParamTitle" select="$VarMergeTitle" />
         <xsl:with-param name="ParamTOCPath" select="$VarTOCPath" />
         <xsl:with-param name="ParamIndexPath" select="$VarIndexPath" />
         <xsl:with-param name="ParamCHMPath" select="concat(wwprojext:GetFormatName(), '.chm')" />
         <xsl:with-param name="ParamMapPath" select="''" />
         <xsl:with-param name="ParamFilesDocumentNodes" select="$GlobalFiles/wwmode:EmptySelection" />
         <xsl:with-param name="ParamCopyFiles" select="$GlobalFiles/wwmode:EmptySelection" />
         <xsl:with-param name="ParamBaggageFiles" select="$GlobalFiles/wwmode:EmptySelection" />
         <xsl:with-param name="ParamWhatIsThisTextPath" select="''" />
         <xsl:with-param name="ParamWhatIsThisHeaderPath" select="''" />
         <xsl:with-param name="ParamMergeFiles" select="$VarMergeFiles" />
        </xsl:call-template>
       </xsl:for-each>
      </xsl:for-each>
     </xsl:if>

     <wwfiles:File path="{$VarMergePath}" type="{$ParameterMergeType}" checksum="{wwfilesystem:GetChecksum($VarMergePath)}" projectchecksum="{$GlobalProject/wwproject:Project/@ChangeID}" groupID="" documentID="" actionchecksum="{$GlobalActionChecksum}" category="{$ParameterMergeCategory}" use="{$ParameterMergeUse}" deploy="{$ParameterMergeDeploy}">
      <wwfiles:Depends path="{$GlobalLocalePath}" checksum="{wwfilesystem:GetChecksum($GlobalLocalePath)}" groupID="" documentID="" />
     </wwfiles:File>
    </xsl:if>
    <xsl:variable name="VarProgressMergeEnd" select="wwprogress:End()" />

    <xsl:variable name="VarProgressGroupsAndMergeEnd" select="wwprogress:End()" />
   </xsl:for-each>
  </wwfiles:Files>
 </xsl:template>


 <xsl:template name="HtmlHelpProject">
  <xsl:param name="ParamLinksFiles" />
  <xsl:param name="ParamDefaultTopic" />
  <xsl:param name="ParamPageOutput" />
  <xsl:param name="ParamImageOutput" />
  <xsl:param name="ParamOutPath" />
  <xsl:param name="ParamLCID" />
  <xsl:param name="ParamTitle" />
  <xsl:param name="ParamTOCPath" />
  <xsl:param name="ParamIndexPath" />
  <xsl:param name="ParamCHMPath" />
  <xsl:param name="ParamMapPath" />
  <xsl:param name="ParamFilesDocumentNodes" />
  <xsl:param name="ParamCopyFiles" />
  <xsl:param name="ParamBaggageFiles" />
  <xsl:param name="ParamWhatIsThisTextPath" />
  <xsl:param name="ParamWhatIsThisHeaderPath" />
  <xsl:param name="ParamMergeFiles" />

  <xsl:variable name="VarReplacementsAsXML">
   <!-- Default topic -->
   <!--               -->
   <xsl:variable name="VarDefaultTopic" select="$ParamDefaultTopic" />

   <!-- Home page -->
   <!--           -->
   <xsl:variable name="VarHomePage" select="$ParamDefaultTopic" />

   <!-- Generate binary TOC -->
   <!--                       -->
   <xsl:variable name="VarGenerateBinaryTOC">
    <xsl:variable name="VarGenerateBinaryTOCHint" select="wwprojext:GetFormatSetting('htmlhelp-binary-toc', 'false')" />
    <xsl:choose>
     <xsl:when test="$VarGenerateBinaryTOCHint = 'true'">
      <xsl:value-of select="'Yes'" />
     </xsl:when>

     <xsl:otherwise>
      <xsl:value-of select="'No'" />
     </xsl:otherwise>
    </xsl:choose>
   </xsl:variable>
   
   <!-- Generate binary index -->
   <!--                       -->
   <xsl:variable name="VarGenerateBinaryIndex">
    <xsl:variable name="VarGenerateBinaryIndexHint" select="wwprojext:GetFormatSetting('htmlhelp-binary-index', 'false')" />
    <xsl:choose>
     <!-- Merged help sets must use binary indices -->
     <!--                                          -->
     <xsl:when test="count($GlobalProject/wwproject:Project/wwproject:Groups/wwproject:Group) &gt; 1">
      <xsl:value-of select="'Yes'" />
     </xsl:when>

     <xsl:when test="$VarGenerateBinaryIndexHint = 'true'">
      <xsl:value-of select="'Yes'" />
     </xsl:when>

     <xsl:otherwise>
      <xsl:value-of select="'No'" />
     </xsl:otherwise>
    </xsl:choose>
   </xsl:variable>

   <!-- Define output files -->
   <!--                     -->
   <xsl:variable name="VarFiles">
    <!-- Iterate output html files -->
    <!--                           -->
    <xsl:for-each select="$ParamPageOutput">
     <xsl:value-of select="wwfilesystem:GetRelativeTo(./@path, $ParamOutPath)" />
     <xsl:value-of select="'&#0013;&#0010;'" />
    </xsl:for-each>

    <!-- Iterate output images -->
    <!--                       -->
    <xsl:for-each select="$ParamImageOutput">
     <xsl:value-of select="wwfilesystem:GetRelativeTo(./@path, $ParamOutPath)" />
     <xsl:value-of select="'&#0013;&#0010;'" />
    </xsl:for-each>

    <!-- Iterate copy files -->
    <!--                    -->
    <xsl:for-each select="$ParamCopyFiles">
     <xsl:variable name="VarRelativeCopyPath" select="wwfilesystem:GetRelativeTo(./@path, $ParamOutPath)" />

     <!-- Exclude map file -->
     <!--                  -->
     <xsl:if test="wwstring:ToLower($VarRelativeCopyPath) != wwstring:ToLower($ParamMapPath)">
      <xsl:value-of select="$VarRelativeCopyPath" />
      <xsl:value-of select="'&#0013;&#0010;'" />
     </xsl:if>
    </xsl:for-each>

    <!-- Iterate baggage files -->
    <!--                       -->
    <xsl:for-each select="$ParamBaggageFiles">
     <xsl:variable name="VarBaggageFile" select="." />

     <xsl:if test="wwfilesystem:FileExists($VarBaggageFile/@path)">
      <xsl:value-of select="wwfilesystem:GetRelativeTo($VarBaggageFile/@path, $ParamOutPath)" />
      <xsl:value-of select="'&#0013;&#0010;'" />
     </xsl:if>
    </xsl:for-each>
   </xsl:variable>

   <!-- Topic aliases -->
   <!--               -->
   <xsl:variable name="VarAliases">
    <!-- Iterate topics -->
    <!--                -->
    <xsl:for-each select="$ParamLinksFiles">
     <xsl:variable name="VarLinkFile" select="." />
     <xsl:for-each select="$VarLinkFile/wwlinks:Paragraph[string-length(@topic) &gt; 0]">
      <xsl:value-of select="@topic"/>
      <xsl:text> = </xsl:text>
      <xsl:value-of select="wwfilesystem:GetRelativeTo($VarLinkFile/@path, $ParamOutPath)"/>
      <xsl:value-of select="'&#0013;&#0010;'" />
     </xsl:for-each>
    </xsl:for-each>
   </xsl:variable>

   <!-- Map Files -->
   <!--           -->
   <xsl:variable name="VarMapFilesWithPrefix">
    <xsl:if test="string-length($ParamMapPath) &gt; 0">
     <xsl:value-of select="'&#0013;&#0010;'" />
     <xsl:text>#include </xsl:text>
     <xsl:value-of select="$ParamMapPath" />
    </xsl:if>

    <xsl:if test="string-length($ParamWhatIsThisHeaderPath) &gt; 0">
     <xsl:value-of select="'&#0013;&#0010;'" />
     <xsl:text>#include </xsl:text>
     <xsl:value-of select="wwfilesystem:GetRelativeTo($ParamWhatIsThisHeaderPath, $ParamOutPath)" />
    </xsl:if>
   </xsl:variable>
   <xsl:variable name="VarMapFiles">
    <xsl:if test="string-length($VarMapFilesWithPrefix &gt; 0)">
     <xsl:value-of select="substring-after($VarMapFilesWithPrefix, '&#0013;&#0010;')" />
    </xsl:if>
   </xsl:variable>

   <!-- What Is This files -->
   <!--                    -->
   <xsl:variable name="VarWhatIsThisFilesWithPrefix">
    <xsl:if test="string-length($ParamWhatIsThisHeaderPath) &gt; 0">
     <xsl:value-of select="'&#0013;&#0010;'" />
     <xsl:value-of select="wwfilesystem:GetRelativeTo($ParamWhatIsThisHeaderPath, $ParamOutPath)" />
    </xsl:if>

    <xsl:if test="string-length($ParamWhatIsThisTextPath) &gt; 0">
     <xsl:value-of select="'&#0013;&#0010;'" />
     <xsl:value-of select="wwfilesystem:GetRelativeTo($ParamWhatIsThisTextPath, $ParamOutPath)" />
    </xsl:if>
   </xsl:variable>
   <xsl:variable name="VarWhatIsThisFiles">
    <xsl:if test="string-length($VarWhatIsThisFilesWithPrefix &gt; 0)">
     <xsl:value-of select="substring-after($VarWhatIsThisFilesWithPrefix, '&#0013;&#0010;')" />
    </xsl:if>
   </xsl:variable>

   <!-- Merge files -->
   <!--             -->
   <xsl:variable name="VarMergeFiles">
    <xsl:for-each select="$ParamMergeFiles">
     <xsl:value-of select="wwfilesystem:GetRelativeTo(./@path, $ParamOutPath)" />
     <xsl:value-of select="'&#0013;&#0010;'" />
    </xsl:for-each>
   </xsl:variable>

   <wwmultisere:Entry match="$DefaultTopic;" replacement="{$VarDefaultTopic}" />
   <wwmultisere:Entry match="$HomePage;" replacement="{$VarHomePage}" />
   <wwmultisere:Entry match="$BinaryTOC;" replacement="{$VarGenerateBinaryTOC}" />
   <wwmultisere:Entry match="$BinaryIndex;" replacement="{$VarGenerateBinaryIndex}" />
   <wwmultisere:Entry match="$CompiledFile;" replacement="{$ParamCHMPath}" />
   <wwmultisere:Entry match="$TOCName;" replacement="{$ParamTOCPath}" />
   <wwmultisere:Entry match="$IndexName;" replacement="{$ParamIndexPath}" />
   <wwmultisere:Entry match="$LCID;" replacement="{$ParamLCID}" />
   <wwmultisere:Entry match="$Title;" replacement="{$ParamTitle}" />
   <wwmultisere:Entry match="$WindowDefinition;" replacement="" />
   <wwmultisere:Entry match="$Files;" replacement="{$VarFiles}" />
   <wwmultisere:Entry match="$Aliases;" replacement="{$VarAliases}" />
   <wwmultisere:Entry match="$MapFiles;" replacement="{$VarMapFiles}" />
   <wwmultisere:Entry match="$WhatIsThisFiles;" replacement="{$VarWhatIsThisFiles}" />
   <wwmultisere:Entry match="$MergeFiles;" replacement="{$VarMergeFiles}" />
  </xsl:variable>
  <xsl:variable name="VarReplacements" select="msxsl:node-set($VarReplacementsAsXML)/*" />
  <xsl:variable name="VarEncoding" select="wwunits:EncodingFromCodePage($GlobalLocale/wwlocale:Locale/@codepage)" />
  <xsl:value-of select="wwmultisere:ReplaceAllInFile('UTF-8', $GlobalHHPPageTemplatePath, $VarEncoding, $ParamOutPath, $VarReplacements)" />
 </xsl:template>
</xsl:stylesheet>
